/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fife.ui.rsyntaxtextarea.RSTAView;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenPainter;
import org.fife.ui.rsyntaxtextarea.TokenUtils;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.Gutter;

public class WrappedSyntaxView
extends BoxView
implements TabExpander,
RSTAView {
    private int tabBase;
    private int tabSize;
    private Segment s;
    private Segment drawSeg;
    private Rectangle tempRect;
    private RSyntaxTextArea host;
    private FontMetrics metrics;
    private TokenImpl tempToken = new TokenImpl();
    private TokenImpl lineCountTempToken;
    private static final int MIN_WIDTH = 20;

    public WrappedSyntaxView(Element elem) {
        super(elem, 1);
        this.s = new Segment();
        this.drawSeg = new Segment();
        this.tempRect = new Rectangle();
        this.lineCountTempToken = new TokenImpl();
    }

    protected int calculateBreakPosition(int p0, Token tokenList, float x0) {
        int p2 = p0;
        RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
        float currentWidth = this.getWidth();
        if (currentWidth == 2.1474836E9f) {
            currentWidth = this.getPreferredSpan(0);
        }
        currentWidth = Math.max(currentWidth, 20.0f);
        for (Token t2 = tokenList; t2 != null && t2.isPaintable(); t2 = t2.getNextToken()) {
            float tokenWidth = t2.getWidth(textArea, this, x0);
            if (tokenWidth > currentWidth) {
                if (p2 == p0) {
                    return t2.getOffsetBeforeX(textArea, this, 0.0f, currentWidth);
                }
                return t2.isWhitespace() ? p2 + t2.length() : p2;
            }
            currentWidth -= tokenWidth;
            x0 += tokenWidth;
            p2 += t2.length();
        }
        return p2 + 1;
    }

    @Override
    public void changedUpdate(DocumentEvent e2, Shape a2, ViewFactory f2) {
        this.updateChildren(e2, a2);
    }

    private void childAllocation2(int line, int y2, Rectangle alloc) {
        alloc.x += this.getOffset(0, line);
        alloc.y += y2;
        alloc.width = this.getSpan(0, line);
        alloc.height = this.getSpan(1, line);
        Insets margin = this.host.getMargin();
        if (margin != null) {
            alloc.y -= margin.top;
        }
    }

    protected void drawView(TokenPainter painter, Graphics2D g2, Rectangle r2, View view, int fontHeight, int y2, int line) {
        float x2 = r2.x;
        RSyntaxTextAreaHighlighter h2 = (RSyntaxTextAreaHighlighter)this.host.getHighlighter();
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Element map = this.getElement();
        int p0 = view.getStartOffset();
        int lineNumber = map.getElementIndex(p0);
        int p1 = view.getEndOffset();
        this.setSegment(p0, p1 - 1, document, this.drawSeg);
        int start = p0 - this.drawSeg.offset;
        Token token = document.getTokenListForLine(lineNumber);
        if (token != null && token.getType() == 0) {
            h2.paintLayeredHighlights(g2, p0, p1, r2, this.host, this);
            return;
        }
        while (token != null && token.isPaintable()) {
            int p2 = this.calculateBreakPosition(p0, token, x2);
            x2 = r2.x;
            h2.paintLayeredHighlights(g2, p0, p2, r2, this.host, this);
            while (token != null && token.isPaintable() && token.getEndOffset() - 1 < p2) {
                boolean paintBG = this.host.getPaintTokenBackgrounds(line, y2);
                x2 = painter.paint(token, g2, x2, y2, this.host, this, 0.0f, paintBG);
                token = token.getNextToken();
            }
            if (token != null && token.isPaintable() && token.getOffset() < p2) {
                int tokenOffset = token.getOffset();
                this.tempToken.set(this.drawSeg.array, tokenOffset - start, p2 - 1 - start, tokenOffset, token.getType());
                this.tempToken.setLanguageIndex(token.getLanguageIndex());
                boolean paintBG = this.host.getPaintTokenBackgrounds(line, y2);
                painter.paint(this.tempToken, g2, x2, y2, this.host, this, 0.0f, paintBG);
                this.tempToken.copyFrom(token);
                this.tempToken.makeStartAt(p2);
                token = new TokenImpl(this.tempToken);
            }
            h2.paintParserHighlights(g2, p0, p2, r2, this.host, this);
            p0 = p2 == p0 ? p1 : p2;
            y2 += fontHeight;
        }
        if (this.host.getEOLMarkersVisible()) {
            g2.setColor(this.host.getForegroundForTokenType(21));
            g2.setFont(this.host.getFontForTokenType(21));
            g2.drawString("\u00b6", x2, (float)y2 - (float)fontHeight);
        }
    }

    protected void drawViewWithSelection(TokenPainter painter, Graphics2D g2, Rectangle r2, View view, int fontHeight, int y2, int selStart, int selEnd) {
        float x2 = r2.x;
        boolean useSTC = this.host.getUseSelectedTextColor();
        RSyntaxTextAreaHighlighter h2 = (RSyntaxTextAreaHighlighter)this.host.getHighlighter();
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Element map = this.getElement();
        int p0 = view.getStartOffset();
        int lineNumber = map.getElementIndex(p0);
        int p1 = view.getEndOffset();
        this.setSegment(p0, p1 - 1, document, this.drawSeg);
        int start = p0 - this.drawSeg.offset;
        Token token = document.getTokenListForLine(lineNumber);
        if (token != null && token.getType() == 0) {
            h2.paintLayeredHighlights(g2, p0, p1, r2, this.host, this);
            return;
        }
        while (token != null && token.isPaintable()) {
            int p2 = this.calculateBreakPosition(p0, token, x2);
            x2 = r2.x;
            h2.paintLayeredHighlights(g2, p0, p2, r2, this.host, this);
            while (token != null && token.isPaintable() && token.getEndOffset() - 1 < p2) {
                if (token.containsPosition(selStart)) {
                    int selCount;
                    if (selStart > token.getOffset()) {
                        this.tempToken.copyFrom(token);
                        this.tempToken.textCount = selStart - this.tempToken.getOffset();
                        x2 = painter.paint(this.tempToken, g2, x2, y2, this.host, this);
                        this.tempToken.textCount = token.length();
                        this.tempToken.makeStartAt(selStart);
                        token = new TokenImpl(this.tempToken);
                    }
                    if ((selCount = Math.min(token.length(), selEnd - token.getOffset())) == token.length()) {
                        x2 = painter.paintSelected(token, g2, x2, y2, this.host, this, useSTC);
                    } else {
                        this.tempToken.copyFrom(token);
                        this.tempToken.textCount = selCount;
                        x2 = painter.paintSelected(this.tempToken, g2, x2, y2, this.host, this, useSTC);
                        this.tempToken.textCount = token.length();
                        this.tempToken.makeStartAt(token.getOffset() + selCount);
                        token = this.tempToken;
                        x2 = painter.paint(token, g2, x2, y2, this.host, this);
                    }
                } else if (token.containsPosition(selEnd)) {
                    this.tempToken.copyFrom(token);
                    this.tempToken.textCount = selEnd - this.tempToken.getOffset();
                    x2 = painter.paintSelected(this.tempToken, g2, x2, y2, this.host, this, useSTC);
                    this.tempToken.textCount = token.length();
                    this.tempToken.makeStartAt(selEnd);
                    token = this.tempToken;
                    x2 = painter.paint(token, g2, x2, y2, this.host, this);
                } else {
                    x2 = token.getOffset() >= selStart && token.getEndOffset() <= selEnd ? painter.paintSelected(token, g2, x2, y2, this.host, this, useSTC) : painter.paint(token, g2, x2, y2, this.host, this);
                }
                token = token.getNextToken();
            }
            if (token != null && token.isPaintable() && token.getOffset() < p2) {
                int tokenOffset = token.getOffset();
                Token orig = token;
                token = new TokenImpl(this.drawSeg, tokenOffset - start, p2 - 1 - start, tokenOffset, token.getType(), token.getLanguageIndex());
                token.setLanguageIndex(token.getLanguageIndex());
                if (token.containsPosition(selStart)) {
                    int selCount;
                    if (selStart > token.getOffset()) {
                        this.tempToken.copyFrom(token);
                        this.tempToken.textCount = selStart - this.tempToken.getOffset();
                        x2 = painter.paint(this.tempToken, g2, x2, y2, this.host, this);
                        this.tempToken.textCount = token.length();
                        this.tempToken.makeStartAt(selStart);
                        token = new TokenImpl(this.tempToken);
                    }
                    if ((selCount = Math.min(token.length(), selEnd - token.getOffset())) == token.length()) {
                        x2 = painter.paintSelected(token, g2, x2, y2, this.host, this, useSTC);
                    } else {
                        this.tempToken.copyFrom(token);
                        this.tempToken.textCount = selCount;
                        x2 = painter.paintSelected(this.tempToken, g2, x2, y2, this.host, this, useSTC);
                        this.tempToken.textCount = token.length();
                        this.tempToken.makeStartAt(token.getOffset() + selCount);
                        token = this.tempToken;
                        x2 = painter.paint(token, g2, x2, y2, this.host, this);
                    }
                } else if (token.containsPosition(selEnd)) {
                    this.tempToken.copyFrom(token);
                    this.tempToken.textCount = selEnd - this.tempToken.getOffset();
                    x2 = painter.paintSelected(this.tempToken, g2, x2, y2, this.host, this, useSTC);
                    this.tempToken.textCount = token.length();
                    this.tempToken.makeStartAt(selEnd);
                    token = this.tempToken;
                    x2 = painter.paint(token, g2, x2, y2, this.host, this);
                } else {
                    x2 = token.getOffset() >= selStart && token.getEndOffset() <= selEnd ? painter.paintSelected(token, g2, x2, y2, this.host, this, useSTC) : painter.paint(token, g2, x2, y2, this.host, this);
                }
                token = new TokenImpl(orig);
                ((TokenImpl)token).makeStartAt(p2);
            }
            h2.paintParserHighlights(g2, p0, p2, r2, this.host, this);
            p0 = p2 == p0 ? p1 : p2;
            y2 += fontHeight;
        }
        if (this.host.getEOLMarkersVisible()) {
            g2.setColor(this.host.getForegroundForTokenType(21));
            g2.setFont(this.host.getFontForTokenType(21));
            g2.drawString("\u00b6", x2, (float)y2 - (float)fontHeight);
        }
    }

    @Override
    public Shape getChildAllocation(int index, Shape a2) {
        if (a2 != null) {
            Shape ca2 = this.getChildAllocationImpl(index, a2);
            if (ca2 != null && !this.isAllocationValid()) {
                Rectangle r2;
                Rectangle rectangle = r2 = ca2 instanceof Rectangle ? (Rectangle)ca2 : ca2.getBounds();
                if (r2.width == 0 && r2.height == 0) {
                    return null;
                }
            }
            return ca2;
        }
        return null;
    }

    public Shape getChildAllocationImpl(int line, Shape a2) {
        Rectangle alloc = this.getInsideAllocation(a2);
        this.host = (RSyntaxTextArea)this.getContainer();
        FoldManager fm2 = this.host.getFoldManager();
        int y2 = alloc.y;
        for (int i2 = 0; i2 < line; ++i2) {
            y2 += this.getSpan(1, i2);
            Fold fold = fm2.getFoldForLine(i2);
            if (fold == null || !fold.isCollapsed()) continue;
            i2 += fold.getCollapsedLineCount();
        }
        this.childAllocation2(line, y2, alloc);
        return alloc;
    }

    @Override
    public float getMaximumSpan(int axis) {
        this.updateMetrics();
        float span = super.getPreferredSpan(axis);
        if (axis == 0) {
            span += (float)this.metrics.charWidth('\u00b6');
        }
        return span;
    }

    @Override
    public float getMinimumSpan(int axis) {
        this.updateMetrics();
        float span = super.getPreferredSpan(axis);
        if (axis == 0) {
            span += (float)this.metrics.charWidth('\u00b6');
        }
        return span;
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        float span = 0.0f;
        if (axis == 0) {
            span = super.getPreferredSpan(axis);
            span += (float)this.metrics.charWidth('\u00b6');
        } else {
            span = super.getPreferredSpan(axis);
            this.host = (RSyntaxTextArea)this.getContainer();
            if (this.host.isCodeFoldingEnabled()) {
                int lineCount = this.host.getLineCount();
                FoldManager fm2 = this.host.getFoldManager();
                for (int i2 = 0; i2 < lineCount; ++i2) {
                    if (!fm2.isLineHidden(i2)) continue;
                    span -= (float)this.getSpan(1, i2);
                }
            }
        }
        return span;
    }

    protected int getTabSize() {
        Integer i2 = (Integer)this.getDocument().getProperty("tabSize");
        int size = i2 != null ? i2 : 5;
        return size;
    }

    @Override
    protected View getViewAtPoint(int x2, int y2, Rectangle alloc) {
        int lineCount = this.getViewCount();
        int curY = alloc.y + this.getOffset(1, 0);
        this.host = (RSyntaxTextArea)this.getContainer();
        FoldManager fm2 = this.host.getFoldManager();
        for (int line = 1; line < lineCount; ++line) {
            int span = this.getSpan(1, line - 1);
            if (y2 < curY + span) {
                this.childAllocation2(line - 1, curY, alloc);
                return this.getView(line - 1);
            }
            curY += span;
            Fold fold = fm2.getFoldForLine(line - 1);
            if (fold == null || !fold.isCollapsed()) continue;
            line += fold.getCollapsedLineCount();
        }
        this.childAllocation2(lineCount - 1, curY, alloc);
        return this.getView(lineCount - 1);
    }

    @Override
    public void insertUpdate(DocumentEvent changes, Shape a2, ViewFactory f2) {
        this.updateChildren(changes, a2);
        Rectangle alloc = a2 != null && this.isAllocationValid() ? this.getInsideAllocation(a2) : null;
        int pos = changes.getOffset();
        View v2 = this.getViewAtPosition(pos, alloc);
        if (v2 != null) {
            v2.insertUpdate(changes, alloc, f2);
        }
    }

    @Override
    protected void loadChildren(ViewFactory f2) {
        Element e2 = this.getElement();
        int n2 = e2.getElementCount();
        if (n2 > 0) {
            View[] added = new View[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                added[i2] = new WrappedLine(e2.getElement(i2));
            }
            this.replace(0, 0, added);
        }
    }

    @Override
    public Shape modelToView(int pos, Shape a2, Position.Bias b2) throws BadLocationException {
        View v2;
        int testPos;
        if (!this.isAllocationValid()) {
            Rectangle alloc = a2.getBounds();
            this.setSize(alloc.width, alloc.height);
        }
        boolean isBackward = b2 == Position.Bias.Backward;
        int n2 = testPos = isBackward ? Math.max(0, pos - 1) : pos;
        if (isBackward && testPos < this.getStartOffset()) {
            return null;
        }
        int vIndex = this.getViewIndexAtPosition(testPos);
        if (vIndex != -1 && vIndex < this.getViewCount() && (v2 = this.getView(vIndex)) != null && testPos >= v2.getStartOffset() && testPos < v2.getEndOffset()) {
            Shape childShape = this.getChildAllocation(vIndex, a2);
            if (childShape == null) {
                return null;
            }
            Shape retShape = v2.modelToView(pos, childShape, b2);
            if (retShape == null && v2.getEndOffset() == pos && ++vIndex < this.getViewCount()) {
                v2 = this.getView(vIndex);
                retShape = v2.modelToView(pos, this.getChildAllocation(vIndex, a2), b2);
            }
            return retShape;
        }
        throw new BadLocationException("Position not represented by view", pos);
    }

    @Override
    public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a2) throws BadLocationException {
        Rectangle r1;
        Shape s1;
        Shape s0 = this.modelToView(p0, a2, b0);
        if (p1 == this.getEndOffset()) {
            try {
                s1 = this.modelToView(p1, a2, b1);
            }
            catch (BadLocationException ble) {
                s1 = null;
            }
            if (s1 == null) {
                Rectangle alloc = a2 instanceof Rectangle ? (Rectangle)a2 : a2.getBounds();
                s1 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
            }
        } else {
            s1 = this.modelToView(p1, a2, b1);
        }
        Rectangle r0 = s0.getBounds();
        Rectangle rectangle = r1 = s1 instanceof Rectangle ? (Rectangle)s1 : s1.getBounds();
        if (r0.y != r1.y) {
            Rectangle alloc = a2 instanceof Rectangle ? (Rectangle)a2 : a2.getBounds();
            r0.x = alloc.x;
            r0.width = alloc.width;
        }
        r0.add(r1);
        if (p1 > p0) {
            r0.width -= r1.width;
        }
        return r0;
    }

    @Override
    public float nextTabStop(float x2, int tabOffset) {
        if (this.tabSize == 0) {
            return x2;
        }
        int ntabs = ((int)x2 - this.tabBase) / this.tabSize;
        return (float)this.tabBase + ((float)ntabs + 1.0f) * (float)this.tabSize;
    }

    @Override
    public void paint(Graphics g2, Shape a2) {
        Rectangle alloc = a2 instanceof Rectangle ? (Rectangle)a2 : a2.getBounds();
        this.tabBase = alloc.x;
        Graphics2D g2d = (Graphics2D)g2;
        this.host = (RSyntaxTextArea)this.getContainer();
        int ascent = this.host.getMaxAscent();
        int fontHeight = this.host.getLineHeight();
        FoldManager fm2 = this.host.getFoldManager();
        TokenPainter painter = this.host.getTokenPainter();
        Element root = this.getElement();
        int selStart = this.host.getSelectionStart();
        int selEnd = this.host.getSelectionEnd();
        int n2 = this.getViewCount();
        int x2 = alloc.x + this.getLeftInset();
        this.tempRect.y = alloc.y + this.getTopInset();
        Rectangle clip = g2.getClipBounds();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.tempRect.x = x2 + this.getOffset(0, i2);
            this.tempRect.width = this.getSpan(0, i2);
            this.tempRect.height = this.getSpan(1, i2);
            if (this.tempRect.intersects(clip)) {
                Element lineElement = root.getElement(i2);
                int startOffset = lineElement.getStartOffset();
                int endOffset = lineElement.getEndOffset() - 1;
                View view = this.getView(i2);
                if (selStart == selEnd || startOffset >= selEnd || endOffset < selStart) {
                    this.drawView(painter, g2d, alloc, view, fontHeight, this.tempRect.y + ascent, i2);
                } else {
                    this.drawViewWithSelection(painter, g2d, alloc, view, fontHeight, this.tempRect.y + ascent, selStart, selEnd);
                }
            }
            this.tempRect.y += this.tempRect.height;
            Fold possibleFold = fm2.getFoldForLine(i2);
            if (possibleFold == null || !possibleFold.isCollapsed()) continue;
            i2 += possibleFold.getCollapsedLineCount();
            Color c2 = RSyntaxUtilities.getFoldedLineBottomColor(this.host);
            if (c2 == null) continue;
            g2.setColor(c2);
            g2.drawLine(x2, this.tempRect.y - 1, this.host.getWidth(), this.tempRect.y - 1);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent changes, Shape a2, ViewFactory f2) {
        this.updateChildren(changes, a2);
        Rectangle alloc = a2 != null && this.isAllocationValid() ? this.getInsideAllocation(a2) : null;
        int pos = changes.getOffset();
        View v2 = this.getViewAtPosition(pos, alloc);
        if (v2 != null) {
            v2.removeUpdate(changes, alloc, f2);
        }
    }

    private void setSegment(int p0, int p1, Document document, Segment seg) {
        try {
            document.getText(p0, p1 - p0, seg);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    @Override
    public void setSize(float width, float height) {
        this.updateMetrics();
        if ((int)width != this.getWidth()) {
            this.preferenceChanged(null, true, true);
            this.setWidthChangePending(true);
        }
        super.setSize(width, height);
        this.setWidthChangePending(false);
    }

    private void setWidthChangePending(boolean widthChangePending) {
        int count = this.getViewCount();
        for (int i2 = 0; i2 < count; ++i2) {
            View v2 = this.getView(i2);
            if (!(v2 instanceof WrappedLine)) continue;
            ((WrappedLine)v2).widthChangePending = widthChangePending;
        }
    }

    void updateChildren(DocumentEvent e2, Shape a2) {
        Element elem = this.getElement();
        DocumentEvent.ElementChange ec2 = e2.getChange(elem);
        if (e2.getType() == DocumentEvent.EventType.CHANGE) {
            this.getContainer().repaint();
        } else if (ec2 != null) {
            Element[] removedElems = ec2.getChildrenRemoved();
            Element[] addedElems = ec2.getChildrenAdded();
            View[] added = new View[addedElems.length];
            for (int i2 = 0; i2 < addedElems.length; ++i2) {
                added[i2] = new WrappedLine(addedElems[i2]);
            }
            this.replace(ec2.getIndex(), removedElems.length, added);
            if (a2 != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        this.updateMetrics();
    }

    final void updateMetrics() {
        Container host = this.getContainer();
        Font f2 = host.getFont();
        this.metrics = host.getFontMetrics(f2);
        this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
    }

    @Override
    public int viewToModel(float x2, float y2, Shape a2, Position.Bias[] bias) {
        View v2;
        Rectangle alloc;
        int offs = -1;
        if (!this.isAllocationValid()) {
            alloc = a2.getBounds();
            this.setSize(alloc.width, alloc.height);
        }
        if ((v2 = this.getViewAtPoint((int)x2, (int)y2, alloc = this.getInsideAllocation(a2))) != null) {
            offs = v2.viewToModel(x2, y2, alloc, bias);
            if (this.host.isCodeFoldingEnabled() && v2 == this.getView(this.getViewCount() - 1) && offs == v2.getEndOffset() - 1) {
                offs = this.host.getLastVisibleOffset();
            }
        }
        return offs;
    }

    @Override
    public int yForLine(Rectangle alloc, int line) throws BadLocationException {
        return this.yForLineContaining(alloc, this.getElement().getElement(line).getStartOffset());
    }

    @Override
    public int yForLineContaining(Rectangle alloc, int offs) throws BadLocationException {
        Rectangle r2;
        if (this.isAllocationValid() && (r2 = (Rectangle)this.modelToView(offs, alloc, Position.Bias.Forward)) != null) {
            if (this.host.isCodeFoldingEnabled()) {
                int line = this.host.getLineOfOffset(offs);
                FoldManager fm2 = this.host.getFoldManager();
                if (fm2.isLineHidden(line)) {
                    return -1;
                }
            }
            return r2.y;
        }
        return -1;
    }

    class WrappedLine
    extends View {
        private int nlines;
        private boolean widthChangePending;

        WrappedLine(Element elem) {
            super(elem);
        }

        final int calculateLineCount() {
            int nlines = 0;
            int startOffset = this.getStartOffset();
            int p1 = this.getEndOffset();
            RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
            RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
            Element map = doc.getDefaultRootElement();
            int line = map.getElementIndex(startOffset);
            Token tokenList = doc.getTokenListForLine(line);
            float x0 = 0.0f;
            int p0 = startOffset;
            while (p0 < p1) {
                ++nlines;
                TokenUtils.TokenSubList subList = TokenUtils.getSubTokenList(tokenList, p0, WrappedSyntaxView.this, textArea, x0, WrappedSyntaxView.this.lineCountTempToken);
                x0 = subList != null ? subList.x : x0;
                tokenList = subList != null ? subList.tokenList : null;
                int p2 = WrappedSyntaxView.this.calculateBreakPosition(p0, tokenList, x0);
                p0 = p2 == p0 ? ++p2 : p2;
            }
            return nlines;
        }

        @Override
        public float getPreferredSpan(int axis) {
            switch (axis) {
                case 0: {
                    float width = WrappedSyntaxView.this.getWidth();
                    if (width == 2.1474836E9f) {
                        return 100.0f;
                    }
                    return width;
                }
                case 1: {
                    if (this.nlines == 0 || this.widthChangePending) {
                        this.nlines = this.calculateLineCount();
                        this.widthChangePending = false;
                    }
                    return this.nlines * ((RSyntaxTextArea)this.getContainer()).getLineHeight();
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }

        @Override
        public void paint(Graphics g2, Shape a2) {
        }

        @Override
        public Shape modelToView(int pos, Shape a2, Position.Bias b2) throws BadLocationException {
            Rectangle alloc = a2.getBounds();
            RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
            alloc.height = textArea.getLineHeight();
            alloc.width = 1;
            int p0 = this.getStartOffset();
            int p1 = this.getEndOffset();
            int testP = b2 == Position.Bias.Forward ? pos : Math.max(p0, pos - 1);
            RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
            Element map = doc.getDefaultRootElement();
            int line = map.getElementIndex(p0);
            Token tokenList = doc.getTokenListForLine(line);
            float x0 = alloc.x;
            while (p0 < p1) {
                TokenUtils.TokenSubList subList = TokenUtils.getSubTokenList(tokenList, p0, WrappedSyntaxView.this, textArea, x0, WrappedSyntaxView.this.lineCountTempToken);
                x0 = subList != null ? subList.x : x0;
                tokenList = subList != null ? subList.tokenList : null;
                int p2 = WrappedSyntaxView.this.calculateBreakPosition(p0, tokenList, x0);
                if (pos >= p0 && testP < p2) {
                    alloc = RSyntaxUtilities.getLineWidthUpTo(textArea, WrappedSyntaxView.this.s, p0, pos, WrappedSyntaxView.this, alloc, alloc.x);
                    return alloc;
                }
                if (p2 == p1 - 1 && pos == p1 - 1) {
                    if (pos > p0) {
                        alloc = RSyntaxUtilities.getLineWidthUpTo(textArea, WrappedSyntaxView.this.s, p0, pos, WrappedSyntaxView.this, alloc, alloc.x);
                    }
                    return alloc;
                }
                p0 = p2 == p0 ? p1 : p2;
                alloc.y += alloc.height;
            }
            throw new BadLocationException(null, pos);
        }

        @Override
        public int viewToModel(float fx2, float fy2, Shape a2, Position.Bias[] bias) {
            bias[0] = Position.Bias.Forward;
            Rectangle alloc = (Rectangle)a2;
            RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
            int x2 = (int)fx2;
            int y2 = (int)fy2;
            if (y2 < alloc.y) {
                return this.getStartOffset();
            }
            if (y2 > alloc.y + alloc.height) {
                return this.getEndOffset() - 1;
            }
            RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
            alloc.height = textArea.getLineHeight();
            int p1 = this.getEndOffset();
            Element map = doc.getDefaultRootElement();
            int p0 = this.getStartOffset();
            int line = map.getElementIndex(p0);
            Token tlist = doc.getTokenListForLine(line);
            while (p0 < p1) {
                TokenUtils.TokenSubList subList = TokenUtils.getSubTokenList(tlist, p0, WrappedSyntaxView.this, textArea, alloc.x, WrappedSyntaxView.this.lineCountTempToken);
                tlist = subList != null ? subList.tokenList : null;
                int p2 = WrappedSyntaxView.this.calculateBreakPosition(p0, tlist, alloc.x);
                if (y2 >= alloc.y && y2 < alloc.y + alloc.height) {
                    if (x2 < alloc.x) {
                        return p0;
                    }
                    if (x2 > alloc.x + alloc.width) {
                        return p2 - 1;
                    }
                    if (tlist != null) {
                        int n2 = tlist.getListOffset(textArea, WrappedSyntaxView.this, alloc.x, x2);
                        return Math.max(Math.min(n2, p2 - 1), p0);
                    }
                }
                p0 = p2 == p0 ? p1 : p2;
                alloc.y += alloc.height;
            }
            return this.getEndOffset() - 1;
        }

        private void handleDocumentEvent(DocumentEvent e2, Shape a2, ViewFactory f2) {
            int n2 = this.calculateLineCount();
            if (this.nlines != n2) {
                this.nlines = n2;
                WrappedSyntaxView.this.preferenceChanged(this, false, true);
                RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
                textArea.repaint();
                Gutter gutter = RSyntaxUtilities.getGutter(textArea);
                if (gutter != null) {
                    gutter.revalidate();
                    gutter.repaint();
                }
            } else if (a2 != null) {
                Container c2 = this.getContainer();
                Rectangle alloc = (Rectangle)a2;
                c2.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e2, Shape a2, ViewFactory f2) {
            this.handleDocumentEvent(e2, a2, f2);
        }

        @Override
        public void removeUpdate(DocumentEvent e2, Shape a2, ViewFactory f2) {
            this.handleDocumentEvent(e2, a2, f2);
        }
    }
}

